//
// 3DTouch first try
//
// Alternative Firmware fuer 3DTouch Autolevelling Sensor
// Harald Sattler, 02/2018
//
// Der 3DTouch Sensor ist gedacht dafuer, die Bodenplatte eines 
// 3D-Druckers auszumessen um einer eventuelle Schieflage der 
// Platte auszugleichen. Der Hersteller bietet Anleitungen fuer 
// die Adaption des Sensors an verschiedene 3D-Drucker sowie 
// Patch-Anleitungen um die 3D-Drucker-Software fuer den Gebrauch
// des Sensors zu aktualisieren.
// GRBL bietet keine Unterstuetzung fuer den 3DTouch. Um nichtleitende 
// Oberflaechen auch mit einer GRBL befeuerten CNC Fraese abtasten zu
// koennen, habe ich die Schaltung analysiert und diese alternative 
// Firmware erstellt.
// Im Wesentlichen reduziert sich der Einsatz des Sensors fuer GRBL
// auf das Abtasten ueber den im Sensor eingebauten Hall-Effekt-Sensor
// und die Erzeugung des "Probe"-Impulses bei Beruehrung der Oberflaeche.
// Die Ansteuerung des Sensors ueber das Servo-Signal entfaellt komplett,
// der Taststift wird abhaengig vom Probe-Signal zurueckgezogen oder 
// ausgefahren. Das Ganze erfolgt zeitgesteuert.
// Der initiale Selbsttest wurde nachempfunden, bei Erkennung eines
// Fehlers (der Taststift bewegt sich nicht wie erwartet), blinkt die 
// rote LED am Sensor und es muss ein weiterer Selbsttest-Zyklus 
// eingeleitet werden, indem der Taststift manuell betätigt wird.
// (ggf. nach Behebung des Problems - Taststift bewegt sich nicht frei)
//
// Die alternative Firmware wird von mir fuer den Eigengebrauch des
// Anwenders zur Verfuegung gestellt, die Hardware muss weiterhin vom
// Hersteller bezogen werden, die urspruengliche Funktion des Sensors
// geht bei Aufspielen der Alternativ-Firmware unwiderruflich verloren!!!
//
// Die alternative Firmware aufzuspielen ist kein Kinderspiel, bitte nur 
// in Angriff nehmen, wenn "SMD", "0402" und "Feinleitertechnik" keine 
// boehmischen Doerfer darstellen.
// 
// Verwendung auf eigene Gefahr.
//

// #define NANO 1			// Programmentwicklung auf Arduino Nano V3

// #define LED 5			// PB5 - Pin 1	// Originalbeschaltung
// #define SERVO 0			// PB0 - Pin 5	// Originalbeschaltung
#define PINUP 3				// PB3 - Pin 2
#define PINDOWN 4			// PB4 - Pin 3
#ifdef NANO									// nur fuer Entwicklung auf Nano
	#define LED 9			// 		
	#define LED2 12			// 
	#define SENSOR 2		// PB1 - Pin 6
	#define ZPROBE A4		// PB2 - Pin 7
	#define DELAYNACHPIN 500
#else
	#define LED 0			// PB0 - Pin 5	// neue Beschaltung
	#define SENSOR 1		// PB1 - Pin 6
	#define ZPROBE 2		// PB2 - Pin 7
	#define DELAYNACHPIN 100
#endif

// um Irritationen wegen AN = LOW und AUS = HIGH zu vermeiden...
#define LED_AN 	(digitalWrite(LED, LOW))
#define LED_AUS (digitalWrite(LED, HIGH))

// globale Variablen
volatile bool sensorTripped;// Sensor wurde getriggert
bool flashLED;				// (bisher) kein Fehler aufgetreten
bool selbstTest;			// Selbsttest (noch) nicht erfolgreich abgeschlossen
int i;

//-------------------------------------------------------------
void setup()
{
	flashLED = false;					// (bisher) kein Fehler aufgetreten
	selbstTest = true;					// Selbsttest (noch) nicht erfolgreich abgeschlossen
	
	// Pins konfigurieren und inaktiv schalten
	pinMode(LED, OUTPUT);
	LED_AUS;							// aktiv LOW Ausgang -> LED aus
#ifdef NANO								// nur fuer Entwicklung auf Nano
	pinMode(LED2, OUTPUT);
	digitalWrite(LED2, HIGH);			// aktiv LOW Ausgang -> LED aus
#endif
	pinMode(PINUP, OUTPUT);
	digitalWrite(PINUP, HIGH);			// aktiv LOW Ausgang deaktivieren
	pinMode(PINDOWN, OUTPUT);
	digitalWrite(PINDOWN, HIGH);		// aktiv LOW Ausgang deaktivieren
	pinMode(ZPROBE, OUTPUT);
	digitalWrite(ZPROBE, HIGH);			// aktiv LOW Ausgang deaktivieren
	pinMode(SENSOR, INPUT_PULLUP);
	
	// Interrupt fuer Sensor zuweisen
	// attachInterrupt(digitalPinToInterrupt(SENSOR), touchINT, FALLING);
	attachInterrupt(0, touchINT, FALLING);
	
	pinUp();							// Pin hochziehen -> Default-Stellung
	delay(500);							// keine Hektik...
	sensorTripped = false;				// Flag ruecksetzen

	// Selbsttest starten, der Pin muss zweimal hoch und runter gehen,
	// jedesmal muss ein Sensor-Event ausgeloest werden

	while(selbstTest == true)
	{
		LED_AUS;						// LED aus
		
		// Selbsttest durchfuehren (2mal Pin runter und hoch, 
		//   dabei Check ob die INTs vom Sensor kommen)
		for(i=0; i<1; i++)
		{
			pinDown();						// Pin absenken
			delay(DELAYNACHPIN);			// kurz warten
			if(sensorTripped == true)		// der Sensor-Interrupt muss gekommen sein
			{
				sensorTripped = false;		// ok -> Flag ruecksetzen
				flashLED = false;			// kein Fehler
			}
			else							// kein IRQ -> FEHLER
			{
				flashLED = true;			// LED blinkt hektisch -> Fehler
				// selbstTest = true;			// nochmal testen
			}
			delay(200);						// keine Hektik...
			
			pinUp();						// Pin hochziehen
			delay(DELAYNACHPIN);			// kurz warten
			if(sensorTripped == true)		// der Sensor-Interrupt muss gekommen sein
			{
				sensorTripped = false;		// ok -> Flag ruecksetzen
				flashLED = false;			// kein Fehler
			}
			else							// kein IRQ -> FEHLER
			{
				flashLED = true;			// LED blinkt hektisch -> Fehler
				// selbstTest = true;		// nochmal testen
			}
			delay(200);						// keine Hektik...
		}

// flashLED = false;			// fuer Tests "kein Fehler" festlegen - muss wieder entfernt werden!!!
		if(flashLED == true)				// es ist ein Fehler aufgetreten
		
		{	
			// nach Fehler solange hektisch blinken, bis der Pin manuell betaetigt wurde
			while(sensorTripped == false)	
			{
				digitalWrite(LED, !digitalRead(LED));
				delay(100);
			}
			
			flashLED = false;				// Blinken stoppen
			sensorTripped = false;			// Flag ruecksetzen
			
			// ab hier wieder an den Anfang von Selbsttest
			selbstTest = true;				// nochmal testen
		}
		else								// beim Test kein Fehler aufgetreten -> ok
		{
			flashLED = false;				// Blinken stoppen
			selbstTest = false;				// alles ok, weiter in loop()
			pinDown();						// Pin in Taststellung bringen
			// LED zweimal kurz aufblitzen lassen
			for(i=0; i<2;i++)
			{
				LED_AN;
				delay(50);				
				LED_AUS;
				delay(250);				
			}
			delay(DELAYNACHPIN);			// kurz warten
			sensorTripped = false;			// Flag ruecksetzen
			LED_AUS;						// LED dauernd aus
		}
	}	
}

// ------------------------------------------------------------------------------
void loop()
{
	unsigned long loopTimer;
	unsigned long tripTimer;
	unsigned long lastTriptimer = 0;
	int j;
	bool langePause;
	bool sleepMode;
	
	if(sensorTripped == true)
	{
		digitalWrite(ZPROBE, LOW);		// Meldung an GRBL aktivieren (aktiv low)
		// ZPROBE _muss zuerst_ kommen, da pinUp() 100 ms verzoegert!
		pinUp();						// Pin schnell hochziehen		+ 100 ms
		LED_AN;							// LED kurz an
		delay(250);						// delay fuer LED, ggf. anpassen
		
		digitalWrite(ZPROBE, HIGH);		// Meldung an GRBL deaktivieren
		LED_AUS;						// LED wieder aus
		pinDown();						// Pin wieder in Taststellung	+ 100 ms
		delay(50);
		
		sensorTripped = false;			// Flag zurueck setzen
	}	
}
// ------------------------------------------------------------------------------

// Interruptroutine fuer Sensor
void touchINT()
{
	sensorTripped = true;
}

void pinDown()
{
	digitalWrite(PINDOWN, LOW);			// aktiv LOW Ausgang
	delay(100);							// Wert aus Original Firmware
	digitalWrite(PINDOWN, HIGH);		// aktiv LOW Ausgang
	// sensorTripped = true;				// ------>>> nur fuer DEBUG!!! <<<-------
}

void pinUp()
{
	digitalWrite(PINUP, LOW);			// aktiv LOW Ausgang
	delay(100);							// Wert aus Original Firmware
	digitalWrite(PINUP, HIGH);			// aktiv LOW Ausgang
}
// ------------------------------------------------------------------------------
